;|								;;
	DLMODELER	Dynamic Line Modeler	v.1.3		;;
	By: Andrea Andreetti	2009-02-16			;;
								;;
	Use: command DLMO					;;
	Press TAB to switch mode				;;
	Press Sift+TAB to reverse switch			;;
	Press + or - to change the cicle Modeler		;;
								|;
(vl-load-com)
(princ "\nDLMO v. 1.3 by Andrea Andreetti        -Loaded-")
(princ"\nPress DLMO to start.")


;;					;;
;;	DLModeling DLMO FUNCTION	;;
;;					;;
					;;
(defun c:dlmo ()
(vl-load-com)
;;;(setvar "OSMODE" 0)  
  (cleandlmodelvar)
  (vla-startundomark
    (vla-get-activedocument (vlax-get-acad-object))
  )

  (defun dtr (a) (* pi (/ a 180.0)))
  (defun rtd (a) (/ (* a 180) pi))
  (defun *error* (msg)
    (princ msg)
    (vla-endundomark
      (vla-get-activedocument (vlax-get-acad-object))
    )
    (deletedetector)
    (cleandlmodelvar)
  )
  
  (vl-load-com)
  (setvar "CMDECHO" 0)
  (setq onedition nil)
  (setq choice 0)
  (setq choicelist (list "TRIM" "PICKER" "WAVE" "BUBBLE" "TRAPEZE" "SQUARE" "ROUNDED" "TWISTED" "SMOOTHTWISTED" "CANDLE")
  )
  (setq choicelen (1- (vl-list-length choicelist)))
  (setq funct (nth choice choicelist))
  (princ (strcat "\nCurrent Mode -> " funct))
  (princ "\nSetect Line... ")
  (setq vsv 20.0)
  (setq input (grread t 4 4))

  (while (or (and (setq input (grread t 4 4)) (= (car input) 5))
             (and (= (car input) 2) (= (cadr input) 9))  ; TAB
             (and (= (car input) 2) (= (cadr input) 61)) ;= as +
             (and (= (car input) 2) (= (cadr input) 45)) ;-
             (and (= (car input) 2) (= (cadr input) 43)) ;+
             (= (car input) 3)
         )
    
    ;coord
    (if (or (= (car input) 5) (= (car input) 3))        
      (setq cursorposition (cadr input))

    )
    ;;-
    (if (and (= (car input) 2) (= (cadr input) 45))
      (setq vsv (1+ vsv))
    )
    (if (or (and (= (car input) 2) (= (cadr input) 43)) ;+
            (and (= (car input) 2) (= (cadr input) 61)) ;+
        )
      (setq vsv (1- vsv))
    )
    
    ;;TAB
    (if (and (= (car input) 2) (= (cadr input) 9))
      (progn (if (acet-sys-shift-down)
               (if (eq choice 0)
                 (setq choice choicelen)
                 (setq choice (1- choice))
               )
               (if (eq choice choicelen)
                 (setq choice 0)
                 (setq choice (1+ choice))
               )
             )
             (setq funct (nth choice choicelist))
             (princ (strcat "\nSwitched to -> " funct))
      )
    )    
    
    (if (not onedition)
      (progn (circlecreation cursorposition 4)
             (setq linesitem nil)
             (setq linesitem (ssget "_C" llpoint urpoint))
             (ssdel circdetector linesitem)
             (checkintersecpoints)
      )
      (circlecreation cursorposition 1)
    )
    (if (and onedition (= (car input) 3))
      (if (not istrimmed)
        (go_trim)
        (progn (setq onedition nil
                     istrimmed nil
                     plinemod nil
                     ename00 nil
                     ename01 nil
               )
        )
      )
    )
    (if onedition
      (go_mod)
    )
    (dlmotext 252
              (polar cursorposition (+ 45 (getvar "SNAPANG")) vsd)
              funct
    )
    
  ) ;_while


;(alert (vl-princ-to-string input))

(if  (or
       (= (car input) 25)  ; (25 477)
       (= (car input) 11)  ; (11 0)
     )
  (progn      
      (deletedetector)
      (deleteplmodification)
    (if onedition 
      (command "_undo" "")
    )
 )
  )
  
  (setq onedition nil)
  (deletedetector)
  (deleteplmodification)
  (vla-endundomark
    (vla-get-activedocument (vlax-get-acad-object))
  )
)
					;;
;;					;;
;;	DLModeling DLMO FUNCTION	;;
;;					;;





;;					;;
;;	DLModeling INTERSEC POINTS	;;
;;					;;
					;;
(defun checkintersecpoints ()
  (if (> (setq sscount (sslength linesitem)) 0)
    (progn (setq fpx nil
                 spx nil
           )
           (setq val -1)
           (repeat sscount
             (setq vla-line (vlax-ename->vla-object
                              (setq ename00 (ssname linesitem (setq val (1+ val))))
                            )
             )
             (if (setq jj (vla-intersectwith vla-line
                                             (vlax-ename->vla-object circdetector)
                                             acextendnone
                          )
                 )
               (progn
                 (if (> (vlax-safearray-get-u-bound (vlax-variant-value jj) 1) 0)
                   (progn (circlecreation cursorposition 1)
                          (if (= (car input) 3)
                            (progn (setq onedition t)
                                   (setq _toconstantwidth nil)
                                   (setq _tolayer (vla-get-layer vla-line))
                                   (setq _tocolor (vla-get-color vla-line))
                                   (setq _tolinetype (vla-get-linetype vla-line))
                                   (setq _tolineweight (vla-get-lineweight vla-line))
                                   (setq _tolinetype (vla-get-linetype vla-line))
                                   (if (or
                                         (eq (vla-get-objectname vla-line) "AcDbPolyline")
                                         (eq (vla-get-objectname vla-line) "AcDb2dPolyline")
                                       )                                     
                                     (setq _toconstantwidth (vla-get-constantwidth vla-line))
                                   )
                                   (setq interseclist (vlax-safearray->list (vlax-variant-value jj)))
                                   (setq fpx (list (car interseclist)
                                                   (cadr interseclist)
                                                   (caddr interseclist)
                                             )
                                   )
                                   (if (> (vl-list-length interseclist) 3)
                                     (setq spx (cdddr interseclist))
                                     (setq spx nil)
                                   )
                            )
                          )
                   )
                 )
               )
             )
           )
    )
  )
)
					;;
;;					;;
;;	DLModeling INTERSEC POINTS	;;
;;					;;





;;					;;
;;	DLModeling MODELING		;;
;;					;;
					;;
(defun go_mod ()
  (if (eq funct "BUBBLE")
    (progn (if spx
             (arcplinecreation (list fpx cursorposition spx))
             (plinecreation (list fpx cursorposition))
           )
    )
  )
  ;;	WAVE-BUBBLE-PICKER		;;
  (if (or (eq funct "WAVE") ;(eq funct "BUBBLE")
          (eq funct "PICKER")
      )
    (progn
      (if spx
        (progn (plinecreation (list fpx cursorposition spx))
               (if (eq funct "WAVE")
                 (vl-cmdf "._pedit" "_non" plinemod "_S" "")
               ) ;(if (eq funct "BUBBLE")
 ;  (vl-cmdf "._pedit" "_non" plinemod "_F" "")
 ;)
        )
        (plinecreation (list fpx cursorposition))
      )
    )
  )
  ;;	TRAPEZE-ROUNDED		;;
  (if (or (eq funct "TRAPEZE") (eq funct "ROUNDED"))
    (progn (if spx
             (plinecreation
               (list fpx
                     (polar cursorposition
                            (angle cursorposition fpx)
                            (/ (distance cursorposition fpx) 2.0)
                     )
                     (polar cursorposition
                            (angle cursorposition spx)
                            (/ (distance cursorposition spx) 2.0)
                     )
                     spx
               )
             )
             (plinecreation (list fpx cursorposition))
           )
           (if (eq funct "ROUNDED")
             (vl-cmdf "._pedit" "_non" plinemod "_s" "")
           )
    )
  )
  ;;	SQUARE			;;
  (if (eq funct "SQUARE")
    (progn
      (if spx
        (progn (setq basecenter (polar fpx (angle fpx spx) (/ (distance fpx spx) 2.0)))
               (plinecreation (list fpx
                                    (polar cursorposition
                                           (angle basecenter fpx)
                                           (distance basecenter fpx)
                                    )
                                    (polar cursorposition
                                           (angle basecenter spx)
                                           (distance basecenter spx)
                                    )
                                    spx
                              )
               )
        )
        (plinecreation (list fpx cursorposition))
      )
    )
  )
  ;;	TWISTED-SMOOTHTWISTED	;;
  (if (or (eq funct "TWISTED") (eq funct "SMOOTHTWISTED"))
    (progn
      (if spx
        (progn (setq basecenter (polar fpx (angle fpx spx) (/ (distance fpx spx) 2.0)))
               (plinecreation
                 (list fpx
                       (polar basecenter
                              (angle cursorposition basecenter)
                              (/ (distance cursorposition basecenter) 2.0)
                       )
                       (polar basecenter
                              (+ (dtr 180) (angle cursorposition basecenter))
                              (/ (distance cursorposition basecenter) 2.0)
                       )
                       spx
                 )
               )
               (if (eq funct "SMOOTHTWISTED")
                 (vl-cmdf "._pedit" "_non" plinemod "_s" "")
               )
        )
        (progn
        (plinecreation (list fpx cursorposition))
        (princ "...")
        )
      )
    )
  )
  ;;		CANDLE		;;
  (if (eq funct "CANDLE")
    (progn
      (if spx
        (progn (setq basecenter (polar fpx (angle fpx spx) (/ (distance fpx spx) 2.0)))
               (setq di (/ (distance fpx spx) 2))
               (setq pi1 (polar fpx (angle fpx spx) di))
               (setq fpix (polar pi1
                                 (angle basecenter cursorposition)
                                 (/ (distance basecenter cursorposition) 6.0)
                          )
               )
               (setq pi2 (polar spx (angle spx fpx) di))
               (setq spix (polar pi2
                                 (angle basecenter cursorposition)
                                 (/ (distance basecenter cursorposition) 6.0)
                          )
               )
               (plinecreation (list fpx fpix cursorposition spix spx))
               (vl-cmdf "._pedit" "_non" plinemod "_s" "")
        )
        (plinecreation (list fpx cursorposition))
      )
    )
  )
  ;;		TRIM		;;
  (if (eq funct "TRIM")
    (progn (setq onedition nil)
           (setq istrimmed nil)
           (setq plinemod nil)
    )
  )
)
					;;
;;					;;
;;	DLModeling MODELING		;;
;;					;;
  



;;;(setq i (car(entsel)))
;;;(setq a (getpoint))
;;;(setq b (getpoint))
;;;(command "._break" i a b)
;;					;;
;;	DLModeling TRIM LINE		;;
;;					;;
					;;
(defun go_trim ()
;;;(vla-ENDundomark
;;;    (vla-get-activedocument (vlax-get-acad-object))
;;;  )
  
  (if spx
    (progn
    (command "._Break" ename00 "_non" fpx "_non" spx)
    (setq ename01 (entlast))
    )
    (progn (setq startp (vlax-curve-getstartpoint ename00))
           (setq endp (vlax-curve-getendpoint ename00))
           (if (< (distance startp cursorposition)
                  (distance endp cursorposition)
               )
             (setq sommet startp)
             (setq sommet endp)
           )
           (command "._break" ename00 "_non" fpx "_non" sommet)
    )
  )
  (setq istrimmed t)

;;;(vla-endundomark
;;;    (vla-get-activedocument (vlax-get-acad-object))
;;;  )
  
)
					;;
;;					;;
;;	DLModeling TRIM LINE		;;
;;					;;




;;					;;
;;	DLModeling DELETE MODELER	;;
;;					;;
					;;
(defun deletedetector ()
  (if circdetector
    (progn (vl-cmdf "._erase" circdetector "")
           (setq circdetector nil)
    )
  )
  (if dlmotdata
    (progn (vl-cmdf "._erase" dlmotdata "")
           (setq dlmotdata nil)
    )
  )
)
					;;
;;					;;
;;	DLModeling DELETE MODELER	;;
;;					;;




;;					;;
;;	DLModeling DELETE PLINE		;;
;;					;;
					;;
(defun deleteplmodification ()
  (if plinemod
    (progn (vl-cmdf "._erase" plinemod "") (setq plinemod nil))
  )
)
					;;
;;					;;
;;	DLModeling DELETE PLINE		;;
;;					;;




;;					;;
;;	DLModeling CIRCLE MODELER	;;
;;					;;
					;;
(defun circlecreation (position coul)
  (deletedetector)
  (setq viewsize (getvar "ViewSize"))
  (setq circdetector (entmakex (list '(0 . "CIRCLE")
                                     (cons 62 coul)
                                     (cons 10 position)
                                     (cons 40 (setq vsd (/ viewsize vsv)))
                               )
                     )
  )
  (vla-getboundingbox (vlax-ename->vla-object circdetector)
                      'x
                      'y
  )
  (setq llpoint (vlax-safearray->list x))
  (setq urpoint (vlax-safearray->list y))
)
					;;
;;					;;
;;	DLModeling CIRCLE MODELER	;;
;;					;;





(defun arcplinecreation (vertexpoint)
  (deleteplmodification)

(vl-cmdf "._arc" (nth 0 vertexpoint)(nth 1 vertexpoint)(nth 2 vertexpoint))
(vl-cmdf "._pedit" (entlast) "_Y" "_W" _toconstantwidth "")
(setq vla-plinemod-last (vlax-ename->vla-object (entlast)))
  (vla-put-layer vla-plinemod-last _tolayer)
  (vla-put-color vla-plinemod-last _tocolor)
  (vla-put-linetype vla-plinemod-last _tolinetype)
  (vla-put-lineweight vla-plinemod-last _tolineweight)
  (vla-put-linetype vla-plinemod-last _tolinetype)
;  (if _toconstantwidth
;    (vla-put-constantwidth vla-plinemod-last _toconstantwidth)
;  )
  (setq plinemod (entlast))
)

;;					;;
;;	DLModeling PLINE MODEL		;;
;;					;;
					;;
(defun plinecreation (vertexpoint)
  (deleteplmodification)
  (entmake '((0 . "POLYLINE") (66 . 1)))
  (foreach v vertexpoint
    (entmake (list '(0 . "VERTEX") (cons 10 v)))
  )
  (entmake '((0 . "SEQEND")))
  (setq vla-plinemod-last (vlax-ename->vla-object (entlast)))
  (vla-put-layer vla-plinemod-last _tolayer)
  (vla-put-color vla-plinemod-last _tocolor)
  (vla-put-linetype vla-plinemod-last _tolinetype)
  (vla-put-lineweight vla-plinemod-last _tolineweight)
  (vla-put-linetype vla-plinemod-last _tolinetype)
  (if _toconstantwidth
    (vla-put-constantwidth vla-plinemod-last _toconstantwidth)
  )
  (setq plinemod (entlast))
)
					;;
;;					;;
;;	DLModeling PLINE MODEL		;;
;;					;;






;;					;;
;;	DLModeling MTEXT		;;
;;					;;
					;;
(defun dlmotext (bakgr ;background color
                 coord ;cursor point
                 texte ;TEXT
                )
  (if dlmotdata
    (progn (vl-cmdf "._erase" dlmotdata "")
           (setq dlmotdata nil)
    )
  )
  (setq dlmostring (strcat "{\\fArial|b0|i0|c0|p34;" texte "}"))
  (setq viewsize (getvar "VIEWSIZE"))
  (setq dlmotdata (entmakex (list (cons 0 "MTEXT")
                                  (cons 100 "AcDbEntity")
                                  (cons 100 "AcDbMText")
                                  (cons 1 dlmostring)
                                  (cons 10 (polar coord 0 (/ viewsize 90.0)))
                                  (cons 40 (/ viewsize 70.0))
                                  (cons 50 0.0)
                                  (cons 62 250)
                                  (cons 71 1)
                                  (cons 72 5)
                                  (cons 90 1)
                                  (cons 63 bakgr)
                                  (cons 45 1.2)
                            )
                  )
  )
)
					;;
;;					;;
;;	DLModeling MTEXT		;;
;;					;;





;;					;;
;;	DLModeling clean Variables	;;
;;					;;
					;;
(defun cleanDLmodelVar ()
(setq VarLst '(choice choiceList OnEdition VSV input cursorPosition funct
             linesItem CircDetector LLpoint URpoint isTrimmed sscount FPx SPx vla-line
             jj _toLayer _toColor _toLinetype _toLineweight toLinetype _toConstantWidth
             interseclist interseclist basecenter ename00 isTrimmed sommet StartP endP
             TRIMOK di Fpix pi1 pi2 Spix VSD))
(mapcar '(lambda (l) (set l nil)) VarLst)  
)
					;;
;;					;;
;;	DLModeling clean Variables	;;
;;					;;


;|Visual LISP Format Options
(120 2 1 2 nil "Ende von " 60 20 1 1 0 nil nil nil T)
;*** NE PAS AJOUTER de texte au-dessous du commentaire! ***|;
